// video out module for the DE1-SoC board
// April 3 2013
// by Fred Aulich
// camera input size is 624 X 420
// Dec 14 2015 update frame size adjustments for imput video
// vert, horiz

module camera (
clk_27,		// 27 Mhz clock
vid_vs,		// vertical sync
vid_hs,		// horizontal sync
frame,		// frame size
address_cam,
video_in,
data_caml,
data_camh,
vid_ldl,
vid_ldh,
vid_udl,
vid_udh,
we_cam

);


// signal identification

input 		clk_27; 		
inout 		vid_hs; 		
inout 		vid_vs; 		
input[7:0] 	video_in;

output[15:0] address_cam;
output[15:0] data_caml;
output[15:0] data_camh;
output		vid_ldl;
output		vid_ldh;
output		vid_udl;
output		vid_udh;

output		we_cam;
output		frame;

reg[15:0] address_cam;
reg[15:0] data_caml;
reg[15:0] data_camh;

//internal registers

reg[10:0] horizontal; 
reg[17:0] timer1;
reg[2:0]  timer2;
reg[17:0] vid_address_low;

wire[7:0] video_in;
 
wire vid_ldl = (frame & !timer2[0] & !vid_address_low[1] & !vid_address_low[0] & clk_27 ) ? 1'b1 : 1'b0; // low byte odd address enable
wire vid_ldh = (frame & !timer2[0] & vid_address_low[1] & !vid_address_low[0] & clk_27 ) ? 1'b1 : 1'b0; // high byte odd address enable
wire vid_udl = (frame & timer2[0] & !vid_address_low[1] & !vid_address_low[0] & clk_27 ) ? 1'b1 : 1'b0; // low byte even address enable
wire vid_udh = (frame & timer2[0] & vid_address_low[1] & !vid_address_low[0] & clk_27 ) ? 1'b1 : 1'b0; // high byte even address enable

wire we_cam = (frame & !vid_address_low[0] & clk_27 ) ? 1'b1 : 1'b0; // write enable memory


wire vert = ( ( timer1 > 30 &  timer1 <= 240 ) ) ? 1'b1 : 1'b0; // adjust vertical sync
wire horiz = ( ( horizontal > 300 & horizontal <= 1548) ) ? 1'b1 : 1'b0; // adjust horizontal sync
wire frame = ( horiz  & vert) ? 1'b1 : 1'b0 ; // address range enable


parameter address_0 = 16'h00000;  // lower address start at 0 meg


///////////////////////////////////////////////
///// counter for each 1/2 frame  (vert)	   //
///////////////////////////////////////////////
always @ (posedge vid_hs)
begin
	
	if (! vid_vs)
		timer1 <= address_0;
		else
		
		begin
		
		timer1 <= timer1 + 1;
		end
	end
	
//////////////////////////////////////////////	
////// counter for each 1/2 frame			 ///
//////////////////////////////////////////////

always @ (posedge  vid_vs)
begin

		timer2 <= timer2 + 1;
end

///////////////////////////////////////
////       horizontal counter		   ///
///////////////////////////////////////
always @(posedge clk_27 )

begin
		if (vid_hs)
		horizontal <= 0;
	
		else
		
		begin
		horizontal <= horizontal + 1;
		end

end		

/////////////////////////////////
//  address counter memory		///
/////////////////////////////////

always @ (posedge clk_27)

begin

	if (!vert)	
		begin
			vid_address_low <= address_0;
		end
		
		else
		
		begin	
		if (frame)
			vid_address_low <= vid_address_low + 1;
		end
		
end



//////////////////////////////////////////////
// latch video data and address 				 ///
//////////////////////////////////////////////

always @ (negedge clk_27)

begin

/////////////////////////////////////////
// odd bytes memory frame load 		  ///
/////////////////////////////////////////
	if ( vid_ldl )
		
			begin
			address_cam <= vid_address_low[17:2]; // low byte 
			data_caml[7:0] <= video_in;
			end
			
		else
		
			if ( vid_ldh )
		
			begin
			address_cam <= vid_address_low[17:2]; // high byte
			data_caml[15:8] <= video_in;
			end
			
		else

/////////////////////////////////////////
// even bytes memory frame load 		  ///
/////////////////////////////////////////			
		
			if ( vid_udl )
		
			begin
			address_cam <= vid_address_low[17:2]; // low byte
			data_camh[7:0] <= video_in;
			end
			
		else
		
					
			if ( vid_udh )
		
			begin
			address_cam <= vid_address_low[17:2]; // high byte
			data_camh[15:8] <= video_in;
			end
		

	end

endmodule	
	