// video module for the DE1-SoC board
// Sept 10 2013
// by Fred Aulich
// capture frame from video in and save in low and high memory
// Dec 14 2015
// updated for DE1-SoC

module monitor (
// video out chip

vid_clk		, // 25 Mhz clock to video chip
clk,
vsync			, // video vertical sync
hsync			, // video horizontal sync
vid_blank	, // video blank 
data_motl	,
data_moth	,
address_mot ,
video_mot	,
read			,
oddeven		,
read_lowl	,
read_lowh	,
read_highl	,
read_highh			
);
// signal directions

input 		vid_clk;
input 		clk;
inout[15:0]	data_motl;
inout[15:0]	data_moth;
inout			read_highh;
inout			read_highl;
inout			read_lowh;
inout			read_lowl;

output[7:0]	video_mot;
output[15:0] address_mot;
output	oddeven;

inout 		vsync;
inout 		hsync; 
inout			vid_blank;
inout			read;

// external module registers
reg[7:0]		video_mot;
reg[15:0]	address_mot;
reg[15:0]	data_motl;
reg[15:0]	data_moth;

// internal registers
reg[16:0]	ramaddressl_odd;  // low address read from memory 
reg[16:0]	ramaddressl_even; // high address read from memory 
reg[10:0]	contvidv; // vertical counter
reg[10:0]	contvidh; // horizontal counter

/////////////////////////////////
//// control values 				///
/////////////////////////////////

wire			vsync = ((contvidv >= 491) & (contvidv < 493))? 1'b0 : 1'b1;
wire			hsync = ((contvidh >= 664) & (contvidh < 760))? 1'b0 : 1'b1;
wire			vid_blank = ((contvidv >= 8) & (contvidv <  420) &(contvidh >= 20) & (contvidh < 624))? 1'b1 : 1'b0;
wire			clrvidh = (contvidh <= 800) ? 1'b0 : 1'b1;
wire  		clrvidv = (contvidv <= 525) ? 1'b0 : 1'b1;
wire  		ramvidv = ( ( (contvidv <= 420) ) ? 1'b0 : 1'b1); 

///////////////////////////////////////////
//////// memory enables						////
///////////////////////////////////////////

wire			adden = ( (( contvidh < 624) & (contvidv <= 420) ) ? 1'b1 : 1'b0); // address enable

wire			read = (vid_clk & adden) ? 1'b1 : 1'b0; // oe to memory enable
wire 			read_lowl = ( adden & !ramaddressl_odd[0] & vid_clk & !oddeven ) ? 1'b0 : 1'b1; // low odd address enable
wire			read_highl = (adden & ramaddressl_odd[0] & vid_clk & !oddeven ) ? 1'b0 : 1'b1; // low even address enable
wire			read_lowh = ( adden & !ramaddressl_even[0] & vid_clk & oddeven ) ? 1'b0 : 1'b1; // high odd address enable
wire			read_highh = ( adden & ramaddressl_even[0] & vid_clk & oddeven ) ? 1'b0 : 1'b1; // high even address enable

parameter address_low = 19'h00000;  // lower address start at 0 meg

//////////////////////////////
/// assignment pins        ///
//////////////////////////////

assign oddeven = contvidv[0];

/////////////////////////////////
// horizontal counter         ///
/////////////////////////////////

always @ (posedge vid_clk )

begin 

		if(clrvidh)
		begin
		contvidh <= 0;
		end
		
		else
		begin
		contvidh <= contvidh + 1;
		end
end

/////////////////////////////////////////
//vertical counter when clrvidv is low //
/////////////////////////////////////////

always @ (posedge vid_clk)

begin 

		if (clrvidv)
		begin
		contvidv <= 0;
		end
		
		else
		begin
			if
			(contvidh == 798)
			begin
			contvidv <= contvidv + 1; // 798 horizontal pixels
			end
		end
end

////////////////////////////////////////////////////////
// address counter out to monitor odd lines 			 ////
////////////////////////////////////////////////////////

always @ (posedge vid_clk )

begin 

		if(ramvidv)
		begin
		ramaddressl_odd <= address_low;// memory reset to "0"
		end
		
		else
		begin
		if (adden & !oddeven )
			begin
			ramaddressl_odd <= ramaddressl_odd + 1;
			end 
		end
end

/////////////////////////////////////////////////
// address counter out to monitor even lines   //
/////////////////////////////////////////////////

always @ (posedge vid_clk)

begin 

		if (ramvidv)
		begin
		ramaddressl_even <= address_low; // memory reset to "0"
		end
		
		else
		begin
			if
			(adden & oddeven )
			begin
			ramaddressl_even <= ramaddressl_even + 1; // 798 horizontal pixels
			end
		end
end


////////////////////////////////////////////////////////
//////// latch address and data from memory		     ///
////////////////////////////////////////////////////////

always @ (negedge vid_clk)

begin
		if (!read_lowl )
		begin

		video_mot <= data_motl[7:0];
		address_mot <= ramaddressl_odd[16:1]; // low memory odd byte
		end
		
		else 
		
		
		if (!read_highl )
		begin

		video_mot <= data_motl[15:8];
		address_mot <= ramaddressl_odd[16:1]; // low memory even byte
		end
		
		else
		
		
		if (!read_lowh )
		begin

		video_mot <= data_moth[7:0];
		address_mot <= ramaddressl_even[16:1]; // high memory odd byte
		end
		
		else
		
		
		if (!read_highh )
		begin

		video_mot <= data_moth[15:8];
		address_mot <= ramaddressl_even[16:1]; // high memory even byte
		end
		
end		



endmodule
	